// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Iddnsresolver.pas' rev: 10.00

#ifndef IddnsresolverHPP
#define IddnsresolverHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Idassignednumbers.hpp>	// Pascal unit
#include <Idbuffer.hpp>	// Pascal unit
#include <Idcomponent.hpp>	// Pascal unit
#include <Idglobal.hpp>	// Pascal unit
#include <Idexceptioncore.hpp>	// Pascal unit
#include <Idnetworkcalculator.hpp>	// Pascal unit
#include <Idglobalprotocols.hpp>	// Pascal unit
#include <Iddnscommon.hpp>	// Pascal unit
#include <Idsys.hpp>	// Pascal unit
#include <Idtcpclient.hpp>	// Pascal unit
#include <Idtcpconnection.hpp>	// Pascal unit
#include <Idobjs.hpp>	// Pascal unit
#include <Idudpclient.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Idbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Iddnsresolver
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TQueryRecordTypes { qtA, qtNS, qtMD, qtMF, qtName, qtSOA, qtMB, qtMG, qtMR, qtNull, qtWKS, qtPTR, qtHINFO, qtMINFO, qtMX, qtTXT, qtRT, qtNSAP, qtNSAP_PTR, qtSIG, qtAAAA, qtService, qtNAPTR, qtCERT, qtV6Addr, qtDName, qtR40, qtOptional, qtIXFR, qtAXFR, qtSTAR };
#pragma option pop

typedef Set<TQueryRecordTypes, qtA, qtSTAR>  TQueryType;

#pragma option push -b-
enum TResultSection { rsAnswer, rsNameServer, rsAdditional };
#pragma option pop

typedef Set<TResultSection, rsAnswer, rsAdditional>  TResultSections;

class DELPHICLASS TResultRecord;
class PASCALIMPLEMENTATION TResultRecord : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
protected:
	TQueryRecordTypes FRecType;
	Word FRecClass;
	AnsiString FName;
	unsigned FTTL;
	int FRDataLength;
	DynamicArray<Byte >  FRData;
	TResultSection FSection;
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	__property TQueryRecordTypes RecType = {read=FRecType, nodefault};
	__property Word RecClass = {read=FRecClass, nodefault};
	__property AnsiString Name = {read=FName};
	__property unsigned TTL = {read=FTTL, nodefault};
	__property int RDataLength = {read=FRDataLength, nodefault};
	__property Idglobal::TBytes RData = {read=FRData};
	__property TResultSection Section = {read=FSection, nodefault};
	__fastcall virtual ~TResultRecord(void);
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TResultRecord(Classes::TCollection* Collection) : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	
};


typedef TMetaClass* TResultRecordClass;

class DELPHICLASS TRDATARecord;
class PASCALIMPLEMENTATION TRDATARecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FIPAddress;
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString IPAddress = {read=FIPAddress};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TRDATARecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TRDATARecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TARecord;
class PASCALIMPLEMENTATION TARecord : public TRDATARecord 
{
	typedef TRDATARecord inherited;
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TARecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TARecord(Classes::TCollection* Collection) : TRDATARecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TAAAARecord;
class PASCALIMPLEMENTATION TAAAARecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FAddress;
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	__property AnsiString Address = {read=FAddress};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TAAAARecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TAAAARecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TWKSRecord;
class PASCALIMPLEMENTATION TWKSRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	int FByteCount;
	DynamicArray<Byte >  FData;
	AnsiString FIPAddress;
	Word FProtocol;
	Byte __fastcall GetABit(int AIndex);
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString IPAddress = {read=FIPAddress};
	__property Word Protocol = {read=FProtocol, nodefault};
	__property Byte BitMap[int index] = {read=GetABit};
	__property int ByteCount = {read=FByteCount, nodefault};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TWKSRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TWKSRecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TMXRecord;
class PASCALIMPLEMENTATION TMXRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FExchangeServer;
	Word FPreference;
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString ExchangeServer = {read=FExchangeServer};
	__property Word Preference = {read=FPreference, nodefault};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TMXRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TMXRecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TTextRecord;
class PASCALIMPLEMENTATION TTextRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	Classes::TStrings* FText;
	
public:
	__fastcall virtual TTextRecord(Classes::TCollection* Collection);
	__fastcall virtual ~TTextRecord(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	__property Classes::TStrings* Text = {read=FText};
};


class DELPHICLASS TErrorRecord;
class PASCALIMPLEMENTATION TErrorRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TErrorRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TErrorRecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS THINFORecord;
class PASCALIMPLEMENTATION THINFORecord : public TTextRecord 
{
	typedef TTextRecord inherited;
	
protected:
	AnsiString FCPU;
	AnsiString FOS;
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	__property AnsiString CPU = {read=FCPU};
	__property AnsiString OS = {read=FOS};
public:
	#pragma option push -w-inl
	/* TTextRecord.Create */ inline __fastcall virtual THINFORecord(Classes::TCollection* Collection) : TTextRecord(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TTextRecord.Destroy */ inline __fastcall virtual ~THINFORecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TMINFORecord;
class PASCALIMPLEMENTATION TMINFORecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FResponsiblePerson;
	AnsiString FErrorMailbox;
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString ResponsiblePersonMailbox = {read=FResponsiblePerson};
	__property AnsiString ErrorMailbox = {read=FErrorMailbox};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TMINFORecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TMINFORecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TSOARecord;
class PASCALIMPLEMENTATION TSOARecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	unsigned FSerial;
	unsigned FMinimumTTL;
	unsigned FRefresh;
	unsigned FRetry;
	AnsiString FMNAME;
	AnsiString FRNAME;
	unsigned FExpire;
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString Primary = {read=FMNAME};
	__property AnsiString ResponsiblePerson = {read=FRNAME};
	__property unsigned Serial = {read=FSerial, nodefault};
	__property unsigned Refresh = {read=FRefresh, nodefault};
	__property unsigned Retry = {read=FRetry, nodefault};
	__property unsigned Expire = {read=FExpire, nodefault};
	__property unsigned MinimumTTL = {read=FMinimumTTL, nodefault};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TSOARecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TSOARecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TNAMERecord;
class PASCALIMPLEMENTATION TNAMERecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FHostName;
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString HostName = {read=FHostName};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TNAMERecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TNAMERecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TNSRecord;
class PASCALIMPLEMENTATION TNSRecord : public TNAMERecord 
{
	typedef TNAMERecord inherited;
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TNSRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TNSRecord(Classes::TCollection* Collection) : TNAMERecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TCNRecord;
class PASCALIMPLEMENTATION TCNRecord : public TNAMERecord 
{
	typedef TNAMERecord inherited;
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TCNRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TCNRecord(Classes::TCollection* Collection) : TNAMERecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TSRVRecord;
class PASCALIMPLEMENTATION TSRVRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
private:
	AnsiString FService;
	AnsiString FProtocol;
	int FPriority;
	int FWeight;
	int FPort;
	AnsiString FTarget;
	AnsiString FOriginalName;
	bool __fastcall IsValidIdent(const AnsiString aStr);
	AnsiString __fastcall CleanIdent(const AnsiString aStr);
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString OriginalName = {read=FOriginalName};
	__property AnsiString Service = {read=FService};
	__property AnsiString Protocol = {read=FProtocol};
	__property int Priority = {read=FPriority, nodefault};
	__property int Weight = {read=FWeight, nodefault};
	__property int Port = {read=FPort, nodefault};
	__property AnsiString Target = {read=FTarget};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TSRVRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TSRVRecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TNAPTRRecord;
class PASCALIMPLEMENTATION TNAPTRRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
private:
	int FOrder;
	int FPreference;
	AnsiString FFlags;
	AnsiString FService;
	AnsiString FRegExp;
	AnsiString FReplacement;
	
public:
	virtual void __fastcall Parse(Idglobal::TBytes CompleteMessage, int APos);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property int Order = {read=FOrder, nodefault};
	__property int Preference = {read=FPreference, nodefault};
	__property AnsiString Flags = {read=FFlags};
	__property AnsiString Service = {read=FService};
	__property AnsiString RegExp = {read=FRegExp};
	__property AnsiString Replacement = {read=FReplacement};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TNAPTRRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TNAPTRRecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TQueryResult;
class PASCALIMPLEMENTATION TQueryResult : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TResultRecord* operator[](int Index) { return Items[Index]; }
	
protected:
	AnsiString FDomainName;
	Word FQueryClass;
	Word FQueryType;
	Classes::TStringList* FQueryPointerList;
	AnsiString __fastcall DNSStrToDomain(Idglobal::TBytes SrcStr, int &Idx);
	AnsiString __fastcall NextDNSLabel(Idglobal::TBytes DNSStr, int &APos);
	HIDESBASE void __fastcall SetItem(int Index, TResultRecord* Value);
	HIDESBASE TResultRecord* __fastcall GetItem(int Index);
	
public:
	__fastcall TQueryResult(void);
	__fastcall virtual ~TQueryResult(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASE TResultRecord* __fastcall Add(Idglobal::TBytes Answer, int &APos);
	HIDESBASE void __fastcall Clear(void);
	void __fastcall FilterBySection(const TResultSections aKeep = (Set<TResultSection, rsAnswer, rsAdditional> () << TResultSection(0) ));
	void __fastcall FilterByClass(const TMetaClass* aKeep);
	__property Word QueryClass = {read=FQueryClass, nodefault};
	__property Word QueryType = {read=FQueryType, nodefault};
	__property AnsiString DomainName = {read=FDomainName};
	__property TResultRecord* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
};


class DELPHICLASS TPTRRecord;
class PASCALIMPLEMENTATION TPTRRecord : public TNAMERecord 
{
	typedef TNAMERecord inherited;
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TPTRRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TPTRRecord(Classes::TCollection* Collection) : TNAMERecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TIdDNSResolver;
class PASCALIMPLEMENTATION TIdDNSResolver : public Idtcpconnection::TIdTCPConnection 
{
	typedef Idtcpconnection::TIdTCPConnection inherited;
	
protected:
	bool FAllowRecursiveQueries;
	DynamicArray<Byte >  FInternalQuery;
	int FQuestionLength;
	AnsiString FHost;
	Idglobal::TIdIPVersion FIPVersion;
	int FPort;
	TQueryResult* FQueryResult;
	TQueryType FQueryType;
	int FWaitingTime;
	DynamicArray<Byte >  FPlainTextResult;
	Iddnscommon::TDNSHeader* FDNSHeader;
	void __fastcall SetInternalQuery(const Idglobal::TBytes Value);
	void __fastcall SetPlainTextResult(const Idglobal::TBytes Value);
	virtual void __fastcall InitComponent(void);
	virtual void __fastcall SetIPVersion(const Idglobal::TIdIPVersion AValue);
	Idglobal::TIdIPVersion __fastcall GetIPVersion(void);
	int __fastcall GetPort(void);
	virtual void __fastcall SetPort(const int AValue);
	
public:
	__property Iddnscommon::TDNSHeader* DNSHeader = {read=FDNSHeader};
	void __fastcall ClearInternalQuery(void);
	__fastcall virtual ~TIdDNSResolver(void);
	void __fastcall ParseAnswers(Iddnscommon::TDNSHeader* DNSHeader, Idglobal::TBytes Answer, bool ResetResult = true);
	void __fastcall CreateQuery(AnsiString ADomain, Iddnscommon::TIdRR_SOA* SOARR, int QueryClass = 0x1);
	void __fastcall FillResult(Idglobal::TBytes AResult, bool checkID = true, bool ResetResult = true);
	void __fastcall FillResultWithOutCheckId(AnsiString AResult);
	void __fastcall Resolve(AnsiString ADomain, Iddnscommon::TIdRR_SOA* SOARR = (Iddnscommon::TIdRR_SOA*)(0x0), int QClass = 0x1);
	__property TQueryResult* QueryResult = {read=FQueryResult};
	__property Idglobal::TBytes InternalQuery = {read=FInternalQuery, write=SetInternalQuery};
	__property Idglobal::TBytes PlainTextResult = {read=FPlainTextResult, write=SetPlainTextResult};
	
__published:
	__property TQueryType QueryType = {read=FQueryType, write=FQueryType, nodefault};
	__property int WaitingTime = {read=FWaitingTime, write=FWaitingTime, nodefault};
	__property bool AllowRecursiveQueries = {read=FAllowRecursiveQueries, write=FAllowRecursiveQueries, nodefault};
	__property AnsiString Host = {read=FHost, write=FHost};
	__property int Port = {read=FPort, write=FPort, default=53};
	__property Idglobal::TIdIPVersion IPVersion = {read=GetIPVersion, write=SetIPVersion, nodefault};
public:
	#pragma option push -w-inl
	/* TIdBaseComponent.Create */ inline __fastcall TIdDNSResolver(Classes::TComponent* AOwner)/* overload */ : Idtcpconnection::TIdTCPConnection(AOwner) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint Class_IN = 0x1;
static const Shortint Class_CHAOS = 0x3;
static const Shortint QueryRecordCount = 0x1e;
extern PACKAGE Word QueryRecordValues[31];
extern PACKAGE TQueryRecordTypes QueryRecordTypes[31];

}	/* namespace Iddnsresolver */
using namespace Iddnsresolver;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Iddnsresolver
